﻿IF EXISTS (SELECT 1 FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VX_TR_StratumModifLog_Insert]'))
	DROP TRIGGER [dbo].[VX_TR_StratumModifLog_Insert]
GO

CREATE TRIGGER [dbo].[VX_TR_StratumModifLog_Insert]
	ON [dbo].[Stratum]
	AFTER INSERT
AS
BEGIN
	SET NOCOUNT ON;
	INSERT INTO [dbo].[StratumModifLog] (
		[Respondent],
		[QuotaId],
		[OldStratum],
		[Stratum],
		[OldIncrementValue],
		[IncrementValue],
		[AppName],
		[DateTime]
	)
	SELECT
		inserted.[StrRespondent],
		inserted.[StrQuotaId],
		NULL,
		inserted.[StrStratum],
		NULL,
		inserted.[IncrementValue],
		APP_NAME(),
		GETUTCDATE()
	FROM inserted;
END
GO
